/*
 * Copyright (C) 2012 Saulo Popov Zambiasi
 *
 * This source code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * OverIPSim is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: saulopz@gmail.com
 */

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class Connector implements Runnable {
	private ServerSocket sock;
	private String messageAux;
	private List<String> messages;
	private Thread runner;
	private double error;

	// Constructor Parameters: IP or ServerName and Port
	Connector(int port) {
		super();
		messageAux = null;
		messages = new ArrayList<String>();
		error = 0.1;
		if (port == 0) {
			port = 4400; // default
		}
		try {
			sock = new ServerSocket(port);
		} catch (IOException e) {
			System.out.println("Error: " + e.getMessage());
			System.exit(1);
		}
		if (runner == null) {
			runner = new Thread(this);
			runner.start();
		}
	}

	public void setError(double error) {
		this.error = error / 100;
	}

	public boolean sendMessage(String server, int port, String message) {
		if (message.length() > 255) {
			return false;
		}
		if (Math.random() <= error) {
			return true;
		}
		try {
			Socket conexao = new Socket(server, port);
			conexao.setSoTimeout(20000);
			BufferedOutputStream bos = new BufferedOutputStream(conexao
					.getOutputStream());
			PrintWriter os = new PrintWriter(bos, false);
			os.println(message);
			os.flush();
			conexao.close();
		} catch (IOException e) {
			System.out.println("Error: " + e.getMessage());
		}
		return true;
	}

	public boolean hasMessage() {
		if (Math.random() <= error) {
			if (messageAux == null) {
				if (messages.size() > 0) {
					messageAux = getMessage();
				}
			} else {
				messages.add(messageAux);
				messageAux = null;
			}
		}
		return (messages.size() > 0);
	}

	// If exists messages, get next one
	public String getMessage() {
		if (messages.size() > 0) {
			String out = messages.get(0);
			messages.remove(0);
			return out;
		}
		return null;
	}

	public void run() {
		Socket conexao = null;
		boolean sair = false;
		// Waitting messages
		while (!sair) {
			if (sock == null)
				return;
			try {
				conexao = sock.accept();
				// Receiving a message
				BufferedReader in = new BufferedReader(new InputStreamReader(
						conexao.getInputStream()));
				String message = in.readLine();
				// New message to message list
				messages.add(message);
			} catch (IOException e) {
				System.out.println("Error: " + e.getMessage());
				System.exit(1);
			}
		}
	}

	protected void finalize() throws Throwable {
		try {
			sock.close();
		} finally {
			super.finalize();
		}
	}

	public static void main(String[] args) {
	}
}
