/*
 * Copyright (C) 2012 Saulo Popov Zambiasi
 *
 * This source code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * OverIPSim is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: saulopz@gmail.com
 */

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MyMessage {
	private int index = 0;
	private List<String> arguments = new ArrayList<String>();

	public MyMessage() {
	}

	public MyMessage(String in) {
		StringTokenizer split = new StringTokenizer(in, ":");
		while (split.hasMoreTokens()) {
			String s = split.nextToken();
			if (s != null) {
				arguments.add(unConvert(s));
			}
		}
	}

	public void add(String arg) {
		arguments.add(arg);
	}

	public void reset() {
		index = 0;
	}

	public String next() {
		if (index < arguments.size()) {
			index++;
			return arguments.get(index - 1);
		}
		return "";
	}

	public String toString() {
		String out = "";
		for (int i = 0; i < arguments.size(); i++) {
			if (i != 0) {
				out += ":";
			}
			out += convert(arguments.get(i));
		}
		return out;
	}

	public int size() {
		return arguments.size();
	}

	private static String convert(String in) {
		Pattern regPat = Pattern.compile(":");
		Matcher matcher = regPat.matcher(in);
		return matcher.replaceAll("&dts;");
	}

	private static String unConvert(String in) {
		Pattern regPat = Pattern.compile("&dts;");
		Matcher matcher = regPat.matcher(in);
		return matcher.replaceAll(":");
	}
}
